# -*- coding: utf-8 -*-
"""
Created on Fri Sep  8 16:11:20 2023
####
@author: 123
"""


## 先奖原始文件放入一个文件夹 后批量转成ASCII 再运行该程序
import re
import os
import pandas as pd
from datetime import datetime
import numpy as np
# 指定包含CSV文件的文件夹路径


################### 重采样并计算均值 温度 气压 相对湿度 降水速率 风速 前几分钟算数平均 #时间步长 如要修改 直接改10/30T 1H
# tt='10T'
# tt='30T'
tt='5T'
###################



folder_path = "J:\\BJ MWR\\Y2019\\brt\\"
# folder_path = "J:\\NJ MWR\\Y2022\\M11\\brt\\"
nameyear=folder_path[11:15]
yearls=nameyear[2:]
# namemonth=folder_path[17:19]
# namelist=folder_path[20:23]
namelist=folder_path[16:19]

ariables = ["year","month","day","hour","minute","second","rain flag",
            "22.24Frequencies_BRT(K)","22.51Frequencies_BRT(K)","22.78Frequencies_BRT(K)","23.04Frequencies_BRT(K)","23.31Frequencies_BRT(K)","23.58Frequencies_BRT(K)",
            "23.84Frequencies_BRT(K)","24.37Frequencies_BRT(K)","24.9Frequencies_BRT(K)","25.44Frequencies_BRT(K)","25.71Frequencies_BRT(K)","25.98Frequencies_BRT(K)",
            "26.24Frequencies_BRT(K)","26.77Frequencies_BRT(K)","27.3Frequencies_BRT(K)","27.84Frequencies_BRT(K)","28.37Frequencies_BRT(K)","28.9Frequencies_BRT(K)",
            "30Frequencies_BRT(K)","31.4Frequencies_BRT(K)","31.93Frequencies_BRT(K)","51.26Frequencies_BRT(K)","51.51Frequencies_BRT(K)","51.76Frequencies_BRT(K)",
            "52.01Frequencies_BRT(K)","52.28Frequencies_BRT(K)","52.53Frequencies_BRT(K)","52.78Frequencies_BRT(K)","53.03Frequencies_BRT(K)","53.28Frequencies_BRT(K)",
            "53.86Frequencies_BRT(K)","54.26Frequencies_BRT(K)","54.66Frequencies_BRT(K)","54.94Frequencies_BRT(K)","55.44Frequencies_BRT(K)","55.84Frequencies_BRT(K)",
            "56.66Frequencies_BRT(K)","56.91Frequencies_BRT(K)","57.16Frequencies_BRT(K)","57.3Frequencies_BRT(K)","57.55Frequencies_BRT(K)"," 58.000Frequencies_BRT(K)",
            "elevation_angle(°)","azimuth__angle(°)"]

#
data_types = {col: 'int16' for col in ariables[:7]}
data_types.update({col: 'float32' for col in ariables[7:]})

# 获取文件夹内所有CSV文件的文件名
csv_files = [file for file in os.listdir(folder_path) if file.endswith('.ASC')]

# 创建一个空的DataFrame来存储合并后的数据
data = pd.DataFrame()

# 循环读取每个CSV文件并将其合并到merged_data中
for csv_file in csv_files:
    file_path = os.path.join(folder_path, csv_file)
    print('读取'+csv_file)
    # 读取当前CSV文件的数据
    current_data = pd.read_csv(file_path, sep=',', encoding='gbk', skiprows=8, header=None)
    current_data.columns = ariables
    current_data = current_data.astype(data_types)
    data = pd.concat([data, current_data])

# ####单次 计算
# folder_path = "J:\\NJ MWR\\Y2022\\brt\\220101.BRT.ASC"
# data = pd.read_csv(folder_path, sep=',', encoding='gbk', skiprows=8, header=None)
# data.columns = ariables
# data_types = {col: 'int16' for col in ariables[:7]}
# data_types.update({col: 'float32' for col in ariables[7:]})
# 使用astype方法来设置数据类型
# data = data.astype(data_types)



print('计算中')
# print(data.dtypes)
# 判断第一列是否以2开头的数字 #剔除异常数据

condition = ~data['year'].astype(str).str.startswith(yearls)
# 将不符合条件的整行替换为缺失值
data.loc[condition, :] = np.nan
# 删除整行都缺失的行
data.dropna(how='all', inplace=True)

ls = data[['year', 'month', 'day', 'hour', 'minute', 'second']].astype(int).astype(str).agg('-'.join, axis=1)
data['Timestamp'] = pd.to_datetime(ls, format='%y-%m-%d-%H-%M-%S')

# 将Timestamp列设置为索引
data.set_index('Timestamp', inplace=True)


combined_data = data[["22.24Frequencies_BRT(K)","22.51Frequencies_BRT(K)","22.78Frequencies_BRT(K)","23.04Frequencies_BRT(K)","23.31Frequencies_BRT(K)","23.58Frequencies_BRT(K)",
                "23.84Frequencies_BRT(K)","24.37Frequencies_BRT(K)","24.9Frequencies_BRT(K)","25.44Frequencies_BRT(K)","25.71Frequencies_BRT(K)","25.98Frequencies_BRT(K)",
                "26.24Frequencies_BRT(K)","26.77Frequencies_BRT(K)","27.3Frequencies_BRT(K)","27.84Frequencies_BRT(K)","28.37Frequencies_BRT(K)","28.9Frequencies_BRT(K)",
                "30Frequencies_BRT(K)","31.4Frequencies_BRT(K)","31.93Frequencies_BRT(K)","51.26Frequencies_BRT(K)","51.51Frequencies_BRT(K)","51.76Frequencies_BRT(K)",
                "52.01Frequencies_BRT(K)","52.28Frequencies_BRT(K)","52.53Frequencies_BRT(K)","52.78Frequencies_BRT(K)","53.03Frequencies_BRT(K)","53.28Frequencies_BRT(K)",
                "53.86Frequencies_BRT(K)","54.26Frequencies_BRT(K)","54.66Frequencies_BRT(K)","54.94Frequencies_BRT(K)","55.44Frequencies_BRT(K)","55.84Frequencies_BRT(K)",
                "56.66Frequencies_BRT(K)","56.91Frequencies_BRT(K)","57.16Frequencies_BRT(K)","57.3Frequencies_BRT(K)","57.55Frequencies_BRT(K)"," 58.000Frequencies_BRT(K)",
                "elevation_angle(°)","azimuth__angle(°)"]].resample(tt).mean()

# 重新设置Timestamp列为普通列
combined_data.reset_index(inplace=True)
# print(combined_data.dtypes)

# # 将合并后的数据保存为一个新的CSV文件
combined_data_path = 'J:\\BJ MWR\\'+namelist+'\\'+tt+'\\'+nameyear+'_'+namelist+'_'+tt+'.csv'
# combined_data_path = 'J:\\NJ MWR\\old\\'+namelist+'\\'+tt+'\\'+nameyear+'_'+namelist+'_'+tt+'+.csv'
# combined_data_path = 'J:\\BJ MWR\\'+namelist+'\\'+nameyear+namemonth+'_'+namelist+'_'+tt+'+.csv'
combined_data.to_csv(combined_data_path, index=False,encoding='utf-8')






        